import { InputHTMLAttributes } from 'react';

interface InputProps extends InputHTMLAttributes<HTMLInputElement> {
  label?: string;
  helperText?: string;
  error?: boolean;
}

export function Input({ 
  label, 
  helperText,
  error = false,
  id, 
  className, 
  ...props 
}: InputProps) {
  return (
    <div className="input-wrapper">
      <style jsx>{`
        .input-wrapper {
          display: flex;
          flex-direction: column;
          gap: var(--space-1);
        }
        .input-error {
          border-color: #ef4444;
        }
        .helper-text {
          font-size: var(--text-xs);
          color: var(--text-tertiary);
        }
        .helper-text--error {
          color: #ef4444;
        }
      `}</style>
      {label && <label htmlFor={id}>{label}</label>}
      <input 
        id={id} 
        className={`${className || ''} ${error ? 'input-error' : ''}`} 
        {...props} 
      />
      {helperText && (
        <span className={`helper-text ${error ? 'helper-text--error' : ''}`}>
          {helperText}
        </span>
      )}
    </div>
  );
}
