import { HTMLAttributes } from 'react';

interface DividerProps extends HTMLAttributes<HTMLHRElement> {
  orientation?: 'horizontal' | 'vertical';
  spacing?: 'sm' | 'md' | 'lg';
}

export function Divider({ 
  className, 
  orientation = 'horizontal',
  spacing = 'md',
  ...props 
}: DividerProps) {
  const baseClass = 'wireframe-divider';
  const classes = [baseClass, className].filter(Boolean).join(' ');

  return (
    <>
      <style jsx>{`
        .wireframe-divider[data-spacing="sm"] {
          margin: var(--space-4) 0;
        }
        .wireframe-divider[data-spacing="lg"] {
          margin: var(--space-12) 0;
        }
      `}</style>
      <hr 
        className={classes} 
        data-orientation={orientation}
        data-spacing={spacing !== 'md' ? spacing : undefined}
        {...props} 
      />
    </>
  );
}
