import { HTMLAttributes } from 'react';

interface CardProps extends HTMLAttributes<HTMLDivElement> {
  children: React.ReactNode;
  variant?: 'default' | 'elevated' | 'outlined';
}

export function Card({ className, children, variant = 'default', ...props }: CardProps) {
  const baseClass = 'wireframe-card';
  const variantClass = variant !== 'default' ? `wireframe-card--${variant}` : '';
  const classes = [baseClass, variantClass, className].filter(Boolean).join(' ');

  return (
    <div className={classes} {...props}>
      <style jsx>{`
        .wireframe-card--elevated {
          box-shadow: var(--shadow-md);
        }
        .wireframe-card--outlined {
          box-shadow: none;
          border-width: 2px;
        }
      `}</style>
      {children}
    </div>
  );
}
