import { ButtonHTMLAttributes } from 'react';

interface ButtonProps extends ButtonHTMLAttributes<HTMLButtonElement> {
  children: React.ReactNode;
  variant?: 'default' | 'primary' | 'ghost';
  size?: 'sm' | 'md' | 'lg';
}

export function Button({ 
  className, 
  children, 
  variant = 'default',
  size = 'md',
  ...props 
}: ButtonProps) {
  const dataVariant = variant !== 'default' ? variant : undefined;
  
  return (
    <>
      <style jsx>{`
        button[data-variant="ghost"] {
          background: transparent;
          border-color: transparent;
        }
        button[data-variant="ghost"]:hover {
          background: var(--surface-secondary);
          border-color: transparent;
        }
        button[data-size="sm"] {
          padding: var(--space-1) var(--space-2);
          font-size: var(--text-xs);
        }
        button[data-size="lg"] {
          padding: var(--space-3) var(--space-6);
          font-size: var(--text-base);
        }
      `}</style>
      <button 
        className={className} 
        data-variant={dataVariant}
        data-size={size !== 'md' ? size : undefined}
        {...props}
      >
        {children}
      </button>
    </>
  );
}
