import { Card } from '../wireframe-primitives/Card';
import { Button } from '../wireframe-primitives/Button';
import { Divider } from '../wireframe-primitives/Divider';

export default function Home() {
  return (
    <div>
      <h1>Wireframe Kit</h1>
      <p>
        A minimal prototyping environment with theme support and device previews. 
        Use the controls in the top bar to switch themes and preview on different devices.
      </p>

      <Divider />

      <Card variant="elevated">
        <h2 style={{ marginTop: 0 }}>Getting Started</h2>
        <ol style={{ paddingLeft: '20px' }}>
          <li>Create a new file in <code>app/experiments/your-prototype/page.tsx</code></li>
          <li>Import primitives: Card, Button, Input, Divider</li>
          <li>Build your UI using the components</li>
          <li>Update <code>CLAUDE.md</code> with who/what/why context</li>
        </ol>
        <div style={{ marginTop: '16px' }}>
          <a href="/experiments/starter">
            <Button variant="primary">View Starter Example →</Button>
          </a>
        </div>
      </Card>

      <Divider />

      <h2>Available Experiments</h2>
      <div style={{ display: 'grid', gap: '12px' }}>
        <Card>
          <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
            <div>
              <h3 style={{ margin: 0, marginBottom: '4px' }}>Starter Template</h3>
              <p style={{ margin: 0, fontSize: '14px' }}>
                Basic patterns: list view, detail panel, search, forms
              </p>
            </div>
            <a href="/experiments/starter">
              <Button>Open</Button>
            </a>
          </div>
        </Card>
        
        <Card style={{ borderStyle: 'dashed', opacity: 0.7 }}>
          <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
            <div>
              <h3 style={{ margin: 0, marginBottom: '4px', color: 'var(--text-tertiary)' }}>
                + Add Your Prototype
              </h3>
              <p style={{ margin: 0, fontSize: '14px' }}>
                Create a new folder in <code>app/experiments/</code>
              </p>
            </div>
          </div>
        </Card>
      </div>

      <Divider spacing="lg" />

      <div style={{ display: 'grid', gridTemplateColumns: 'repeat(auto-fit, minmax(250px, 1fr))', gap: '16px' }}>
        <Card>
          <h3 style={{ marginTop: 0 }}>🎨 Themes</h3>
          <p style={{ fontSize: '14px' }}>
            Toggle between Light, Dark, and Wireframe modes using the buttons in the top bar.
          </p>
        </Card>
        <Card>
          <h3 style={{ marginTop: 0 }}>📱 Device Preview</h3>
          <p style={{ fontSize: '14px' }}>
            See how your prototype looks on Desktop, iPad, or iPhone with the device toggles.
          </p>
        </Card>
        <Card>
          <h3 style={{ marginTop: 0 }}>📄 Context Bar</h3>
          <p style={{ fontSize: '14px' }}>
            Click "Context" to see who/what/why from your CLAUDE.md file.
          </p>
        </Card>
      </div>
    </div>
  );
}
