import '../styles/wireframe.css';
import { PrototypeShell } from '../wireframe-primitives/PrototypeShell';
import { loadClaudeMd } from '../lib/parseClaudeMd';

export const metadata = {
  title: 'Wireframe Kit',
};

export default async function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  // Load context from CLAUDE.md
  const context = await loadClaudeMd();

  return (
    <html lang="en" suppressHydrationWarning>
      <head>
        {/* Prevent flash of wrong theme */}
        <script
          dangerouslySetInnerHTML={{
            __html: `
              (function() {
                try {
                  var theme = localStorage.getItem('wireframe-theme');
                  if (theme && ['light', 'dark', 'wireframe'].includes(theme)) {
                    document.documentElement.setAttribute('data-theme', theme);
                  }
                } catch (e) {}
              })();
            `,
          }}
        />
      </head>
      <body>
        <PrototypeShell
          title={context.title}
          who={context.who}
          what={context.what}
          why={context.why}
        >
          <div className="page-wrapper">
            {children}
          </div>
        </PrototypeShell>
      </body>
    </html>
  );
}
