'use client';

import { useState } from 'react';
import { Card } from '../../../wireframe-primitives/Card';
import { Button } from '../../../wireframe-primitives/Button';
import { Input } from '../../../wireframe-primitives/Input';
import { Divider } from '../../../wireframe-primitives/Divider';

// Example mock data
const SAMPLE_ITEMS = [
  { id: '1', title: 'First Item', description: 'This is a sample item to demonstrate the list pattern.' },
  { id: '2', title: 'Second Item', description: 'Items can have descriptions that provide more context.' },
  { id: '3', title: 'Third Item', description: 'Use this pattern for any list-based UI.' },
];

export default function StarterPage() {
  const [selectedId, setSelectedId] = useState<string | null>(null);
  const [searchQuery, setSearchQuery] = useState('');

  const filteredItems = SAMPLE_ITEMS.filter(item =>
    item.title.toLowerCase().includes(searchQuery.toLowerCase())
  );

  const selectedItem = SAMPLE_ITEMS.find(item => item.id === selectedId);

  return (
    <div>
      <h1>Starter Template</h1>
      <p>
        This is a basic example showing common UI patterns. Use the theme and device 
        toggles in the context bar to see how the design adapts.
      </p>

      <Divider />

      {/* Search and Actions */}
      <div style={{ display: 'flex', gap: '12px', marginBottom: '24px', flexWrap: 'wrap' }}>
        <div style={{ flex: 1, minWidth: '200px' }}>
          <Input
            placeholder="Search items..."
            value={searchQuery}
            onChange={(e) => setSearchQuery(e.target.value)}
          />
        </div>
        <Button variant="primary">Add New</Button>
      </div>

      {/* Main Content Grid */}
      <div style={{ display: 'grid', gridTemplateColumns: selectedItem ? '1fr 1fr' : '1fr', gap: '24px' }}>
        {/* List */}
        <div>
          <h3 style={{ marginBottom: '16px' }}>Items ({filteredItems.length})</h3>
          <div style={{ display: 'flex', flexDirection: 'column', gap: '12px' }}>
            {filteredItems.map(item => (
              <Card
                key={item.id}
                variant={selectedId === item.id ? 'elevated' : 'default'}
                onClick={() => setSelectedId(item.id)}
                style={{ cursor: 'pointer' }}
              >
                <h4 style={{ margin: 0, marginBottom: '4px' }}>{item.title}</h4>
                <p style={{ margin: 0, fontSize: '14px' }}>{item.description}</p>
              </Card>
            ))}
            {filteredItems.length === 0 && (
              <p style={{ color: 'var(--text-tertiary)', textAlign: 'center', padding: '24px' }}>
                No items match your search.
              </p>
            )}
          </div>
        </div>

        {/* Detail Panel */}
        {selectedItem && (
          <div>
            <h3 style={{ marginBottom: '16px' }}>Details</h3>
            <Card variant="elevated">
              <h2 style={{ marginTop: 0 }}>{selectedItem.title}</h2>
              <p>{selectedItem.description}</p>
              <Divider spacing="sm" />
              <div style={{ display: 'flex', gap: '8px' }}>
                <Button variant="primary">Edit</Button>
                <Button onClick={() => setSelectedId(null)}>Close</Button>
              </div>
            </Card>
          </div>
        )}
      </div>

      <Divider spacing="lg" />

      {/* Form Example */}
      <Card>
        <h3 style={{ marginTop: 0 }}>Form Example</h3>
        <div style={{ display: 'grid', gap: '16px', maxWidth: '400px' }}>
          <Input label="Name" placeholder="Enter your name" />
          <Input label="Email" placeholder="you@example.com" type="email" />
          <Input label="Message" placeholder="What's on your mind?" />
          <div style={{ display: 'flex', gap: '8px' }}>
            <Button variant="primary">Submit</Button>
            <Button variant="ghost">Cancel</Button>
          </div>
        </div>
      </Card>
    </div>
  );
}
